/***
*
*	Copyright (c) 1999, Valve LLC. All rights reserved.
*	
*	This product contains software technology licensed from Id 
*	Software, Inc. ("Id Technology").  Id Technology (c) 1996 Id Software, Inc. 
*	All Rights Reserved.
*
*   Use, distribution, and modification of this source code and/or resulting
*   object code is restricted to non-commercial enhancements to products from
*   Valve LLC.  All other use, distribution, or modification is prohibited
*   without written permission from Valve LLC.
*
****/
//
// battery.cpp
//
// implementation of CHudSanity class
//

#include "hud.h"
#include "cl_util.h"
#include "parsemsg.h"

#include <string.h>
#include <stdio.h>

DECLARE_MESSAGE(m_Sanity, Sanity)

int CHudSanity::Init(void)
{
	m_iSan = 100;
	m_fFade = 0;
	m_iFlags = 0;

	HOOK_MESSAGE(Sanity);

	gHUD.AddHudElem(this);

	return 1;
};


int CHudSanity::VidInit(void)
{
	int HUD_san_zero = gHUD.GetSpriteIndex( "san_zero" );
	int HUD_san_full = gHUD.GetSpriteIndex( "san_full" );

	m_hSprite1 = m_hSprite2 = 0;  // delaying get sprite handles until we know the sprites are loaded
	m_prc1 = &gHUD.GetSpriteRect( HUD_san_zero );
	m_prc2 = &gHUD.GetSpriteRect( HUD_san_full );
	m_iHeight = m_prc2->bottom - m_prc1->top;
	m_fFade = 0;
	return 1;
};

int CHudSanity:: MsgFunc_Sanity(const char *pszName,  int iSize, void *pbuf )
{
	m_iFlags |= HUD_ACTIVE;

	BEGIN_READ( pbuf, iSize );
	int x = READ_SHORT();

	if (x != m_iSan)
	{
		m_fFade = FADE_TIME;
		m_iSan = x;
	}

	return 1;
}


int CHudSanity::Draw(float flTime)
{
	if ( gHUD.m_iHideHUDDisplay & HIDEHUD_HEALTH )
		return 1;

	int r, g, b, x, y, a;
	wrect_t rc;
//	wrect_t rc_zero;

	rc = *m_prc2;
	rc.top  += m_iHeight * ((float)(100-(min(100,m_iSan))) * 0.01);	// sanity can go from 0 to 100 so * 0.01 goes from 0 to 1

//	rc_zero = *m_prc1;
//	rc_zero.top  += m_iHeight * ((float)(min(100,m_iSan)) * 0.01);	// sanity can go from 0 to 100 so * 0.01 goes from 0 to 1

	UnpackRGB(r,g,b, RGB_YELLOWISH);

	if (!(gHUD.m_iWeaponBits & (1<<(WEAPON_SUIT)) ))
		return 1;

	// Has health changed? Flash the health #
	if (m_fFade)
	{
		if (m_fFade > FADE_TIME)
			m_fFade = FADE_TIME;

		m_fFade -= (gHUD.m_flTimeDelta * 20);
		if (m_fFade <= 0)
		{
			a = 128;
			m_fFade = 0;
		}

		// Fade the health number back to dim

		a = MIN_ALPHA +  (m_fFade/FADE_TIME) * 128;

	}
	else
		a = MIN_ALPHA;

	ScaleColors(r, g, b, a );
	
	int iOffset = (m_prc1->bottom - m_prc1->top)/6;

	y = ScreenHeight - gHUD.m_iFontHeight - gHUD.m_iFontHeight / 2;
	x = ScreenWidth/5;

	// make sure we have the right sprite handles
	if ( !m_hSprite1 )
		m_hSprite1 = gHUD.GetSprite( gHUD.GetSpriteIndex( "san_zero" ) );
	if ( !m_hSprite2 )
		m_hSprite2 = gHUD.GetSprite( gHUD.GetSpriteIndex( "san_full" ) );

	SPR_Set(m_hSprite1, r, g, b );
	SPR_DrawAdditive( 0,  x, y - iOffset, m_prc1);
//	if (rc_zero.bottom > rc_zero.top)
//	{
//		SPR_Set(m_hSprite1, r, g, b );
//		SPR_DrawAdditive( 0,  x, y - iOffset + (rc_zero.top - m_prc1->top), &rc_zero);
//	}

	if (rc.bottom > rc.top)
	{
		SPR_Set(m_hSprite2, r, g, b );
		SPR_DrawAdditive( 0, x, y - iOffset + (rc.top - m_prc2->top), &rc);
	}

	x += (m_prc1->right - m_prc1->left);
	x = gHUD.DrawHudNumber(x, y, DHN_3DIGITS | DHN_DRAWZERO, m_iSan, r, g, b);

	return 1;
}